// Expt 7 Fast convolution using overlap Save method
//O.S. Windows 10
//Scilab 6.0.0
clc;
clear all;
x =[1,2,-1,2,3,-2,-3,-1,1,1,2,-1];
h =[1,2,3,-1];
n1 = length(x);
n2 = length(h);
N = n1+n2-1;
h1 = [h zeros(1,N-n1)];
n3 = length(h1);
y = zeros(1,N);
x1 = [zeros(1,n3-n2) x zeros(1,n3)];
H = fft(h1,-1);
for i = 1:n2:N
y1 = x1(i:i+(2*(n3-n2)));
y2 = fft(y1);
y3 = y2.*H;
y4 = round(fft(y3,1));
y(i:(i+n3-n2)) = y4(n2:n3);
end
subplot(3,1,1);
plot2d3(x(1:n1));
title('Input Sequence x(n)');
xlabel('Time --->');
ylabel('Amplitude --->');
subplot(3,1,2);
plot2d3(h(1:n2));
title('Input Sequence h(n)');
xlabel('Time --->');
ylabel('Amplitude --->');
subplot(3,1,3);
disp('Fast Convolution Using Overlap Save Method = ');
disp(y(1:N));
plot2d3(y(1:N));
title('Block Convolution Using Overlap Save Method');
xlabel('Time --->');
ylabel('Amplitude --->');

// result:Fast Convolution Using Overlap Save Method =
//     1     4     6     5     2    11     0   -16    -8     3     8     5     3    -5     1
